#include <dos.h>
#include <math.h>

extern int rint(double f);
extern double sqrt_(double f);

int T=0;

typedef struct { float x,y,z; } v3;

v3 ro = {0,0,-8};               // ray origin
v3 pn = {0,-1,0}; float pd=-2;  // plane

float dot(v3* a,v3* b) { return a->x*b->x + a->y*b->y + a->z*b->z; }
v3* set(v3* r,float x,float y,float z) { r->x=x; r->y=y; r->z=z; return r; }

void main() {
  do {
    int y;
    unsigned char _es* adr;
    for (adr=0, y=-100; y<100; y++) {
      int x;
      for (x=-160; x<160; x++,adr++) {
        int color;
        int z = 200;
        float l = 1/sqrt_((float)x*x + (float)y*y + (float)z*z);
        v3 rd; set(&rd, x*l, y*l, z*l);  // normalized ray direction

        // ray-plane
        
        {
          float D = dot(&rd,&pn);
          float N = pd - dot(&ro,&pn);  // t*D = N
          float t = N/D;
          if (t>0) {  // hit the plane
            v3 h; set(&h, ro.x+rd.x*t, ro.y+rd.y*t, ro.z+rd.z*t);   // h = ro + rd*t
            {
              int u=rint(h.x), v=rint(h.z+T*0.1);
              color = 7+((u^v)&1)*8;
            }
          }
          else {
            color = 1;
          }
        }
        *adr = color;
      }
    }
    T++;
  } while (inportb(0x60) != 1);
}
